#ifndef _typedef_h
#define _typedef_h


/*************************************************************************************/
//**	Copyright	:	2016 BY HOLTEK SEMICONDUCTOR INC                            **
//** 	File Name   :	TypeDef.c                                                   **
//**	Description	: 	Ͷ												**
//**	MCU      	: 	HT67F5650													**
//**	Author   	: 	LJQ															**
//**	Date     	: 	2016/00/00													**
//**	Version  	: 	V00															**
//**	History  	:																**
/*************************************************************************************/


	typedef unsigned char   BOOL;
	typedef unsigned char   u8;
	typedef unsigned int    u16;
	typedef unsigned long   u32;
	typedef char            s8;
	typedef int             s16;
	typedef long            s32;
	
	#define FALSE           0
	#define TRUE            1
	#define NULL            0
	#define SET             1
	#define OFF             0	
	
	typedef struct
	{
		u8 b0 : 1;
		u8 b1 : 1;
		u8 b2 : 1;
		u8 b3 : 1;
		u8 b4 : 1;
		u8 b5 : 1;
		u8 b6 : 1;
		u8 b7 : 1;
	}__8_bits;
	
	typedef union
	{
		__8_bits bits;
			   u8 U8;
		       s8 S8;
	}__byte_type;
	
	
	typedef struct
	{
		u8 b0  : 1;
		u8 b1  : 1;
		u8 b2  : 1;
		u8 b3  : 1;
		u8 b4  : 1;
		u8 b5  : 1;
		u8 b6  : 1;
		u8 b7  : 1;
		u8 b8  : 1;
		u8 b9  : 1;
		u8 b10 : 1;
		u8 b11 : 1;
		u8 b12 : 1;
		u8 b13 : 1;
		u8 b14 : 1;
		u8 b15 : 1;
	}__16_bits;
	
	typedef union
	{
		struct 
		{
			u8 byte0;
			u8 byte1;
		}byte;
		__16_bits bits;
		u16 U16;
		s16 S16;
	}__16_type;
	
	
	typedef struct
	{
		u8 b0  : 1;
		u8 b1  : 1;
		u8 b2  : 1;
		u8 b3  : 1;
		u8 b4  : 1;
		u8 b5  : 1;
		u8 b6  : 1;
		u8 b7  : 1;
		u8 b8  : 1;
		u8 b9  : 1;
		u8 b10 : 1;
		u8 b11 : 1;
		u8 b12 : 1;
		u8 b13 : 1;
		u8 b14 : 1;
		u8 b15 : 1;
		u8 b16 : 1;
		u8 b17 : 1;
		u8 b18 : 1;
		u8 b19 : 1;
		u8 b20 : 1;
		u8 b21 : 1;
		u8 b22 : 1;
		u8 b23 : 1;
		u8 b24 : 1;
		u8 b25 : 1;
		u8 b26 : 1;
		u8 b27 : 1;
		u8 b28 : 1;
		u8 b29 : 1;
		u8 b30 : 1;
		u8 b31 : 1;
	}__32_bits;
	
	typedef union
	{
		struct 
		{
			u8 byte0;
			u8 byte1;
			u8 byte2;
			u8 byte3;
		}byte;
		__32_bits bits;
		u32 U32;
		s32 S32;
	}__32_type;





#endif